/*
 * Decompiled with CFR 0.152.
 */
package me.angel.tridentrain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.angel.tridentrain.RainType;
import me.angel.tridentrain.Tridentrain;
import net.fabricmc.loader.api.FabricLoader;

public class TridentRainConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("tridentrain.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final int DEFAULT_TRIDENTS_PER_TICK = 2;
    public static final int DEFAULT_FALL_HEIGHT = 50;
    public static final double DEFAULT_SPAWN_RADIUS = 25.0;
    public static final int DEFAULT_SPAWN_FREQUENCY = 10;
    public static final double DEFAULT_MIN_ANGLE = 1.0;
    public static final double DEFAULT_MAX_ANGLE = 15.0;
    public static final double DEFAULT_MIN_SPEED = 0.5;
    public static final double DEFAULT_MAX_SPEED = 0.75;
    public static final boolean DEFAULT_BLOCK_BREAKING = false;
    public static final float DEFAULT_EXPLOSION_CHANCE = 0.05f;
    public static final boolean DEFAULT_ANVIL_DISCARDING = true;
    private int tridentsPerTick = 2;
    private int fallHeight = 50;
    private double spawnRadius = 25.0;
    private int spawnFrequency = 10;
    private double minAngle = 1.0;
    private double maxAngle = 15.0;
    private double minSpeed = 0.5;
    private double maxSpeed = 0.75;
    private boolean blockBreaking = false;
    private boolean explosiveAnvils = false;
    private float explosionChance = 0.05f;
    private boolean anvilDiscarding = true;
    private static final double TRIDENTS_MULTIPLIER = 1.5;
    private static final double FREQUENCY_DIVIDER = 1.2;
    private int currentIntensityLevel = 1;
    private RainType currentRainType = RainType.TRIDENT;

    public static TridentRainConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            TridentRainConfig tridentRainConfig;
            block9: {
                BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
                try {
                    tridentRainConfig = (TridentRainConfig)GSON.fromJson((Reader)reader, TridentRainConfig.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Tridentrain.LOGGER.error("Failed to load config", (Throwable)e);
                    }
                }
                ((Reader)reader).close();
            }
            return tridentRainConfig;
        }
        TridentRainConfig config = new TridentRainConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Tridentrain.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public void applyIntensity(int level) {
        if (level < 1) {
            level = 1;
        }
        if (level > 10) {
            level = 10;
        }
        this.currentIntensityLevel = level;
        this.tridentsPerTick = (int)Math.ceil(2.0 * Math.pow(1.5, level - 1));
        this.spawnFrequency = (int)Math.max(1.0, Math.floor(10.0 / Math.pow(1.2, level - 1)));
        this.save();
    }

    public int getCurrentIntensityLevel() {
        return this.currentIntensityLevel;
    }

    public int getTridentsPerTick() {
        return this.tridentsPerTick;
    }

    public int getFallHeight() {
        return this.fallHeight;
    }

    public double getSpawnRadius() {
        return this.spawnRadius;
    }

    public int getSpawnFrequency() {
        return this.spawnFrequency;
    }

    public double getMinAngle() {
        return this.minAngle;
    }

    public double getMaxAngle() {
        return this.maxAngle;
    }

    public double getMinSpeed() {
        return this.minSpeed;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public boolean isBlockBreaking() {
        return this.blockBreaking;
    }

    public boolean isExplosiveAnvils() {
        return this.explosiveAnvils;
    }

    public float getExplosionChance() {
        return this.explosionChance;
    }

    public boolean isAnvilDiscarding() {
        return this.anvilDiscarding;
    }

    public void setFallHeight(int height) {
        this.fallHeight = Math.max(1, height);
        this.save();
    }

    public void setSpawnRadius(double radius) {
        this.spawnRadius = Math.max(1.0, radius);
        this.save();
    }

    public void setMinAngle(double angle) {
        this.minAngle = Math.max(0.0, Math.min(angle, this.maxAngle));
        this.save();
    }

    public void setMaxAngle(double angle) {
        this.maxAngle = Math.max(this.minAngle, Math.min(angle, 90.0));
        this.save();
    }

    public void setBlockBreaking(boolean enabled) {
        this.blockBreaking = enabled;
        this.save();
    }

    public void setExplosiveAnvils(boolean enabled) {
        this.explosiveAnvils = enabled;
        this.save();
    }

    public void setExplosionChance(float chance) {
        this.explosionChance = Math.max(0.0f, Math.min(1.0f, chance));
        this.save();
    }

    public void setAnvilDiscarding(boolean enabled) {
        this.anvilDiscarding = enabled;
        this.save();
    }

    public RainType getCurrentRainType() {
        return this.currentRainType;
    }

    public void setRainType(RainType type) {
        this.currentRainType = type;
        this.save();
    }

    public void resetToDefaults() {
        this.tridentsPerTick = 2;
        this.fallHeight = 50;
        this.spawnRadius = 25.0;
        this.spawnFrequency = 10;
        this.minAngle = 1.0;
        this.maxAngle = 15.0;
        this.minSpeed = 0.5;
        this.maxSpeed = 0.75;
        this.currentIntensityLevel = 1;
        this.currentRainType = RainType.TRIDENT;
        this.blockBreaking = false;
        this.explosiveAnvils = false;
        this.explosionChance = 0.05f;
        this.anvilDiscarding = true;
        this.save();
    }
}

